' //////////////////////////////////////////////////////////////////////
' TITLE: EPM_Defnder_Sound_Engine1_xxx.spin
'
' DESCRIPTION:
'
' AUTHOR:  Eric Moyer, Copyright (C)2007
'
'
'  Rev  Date      Description
'  ---  --------  ---------------------------------------------------
'  001  11-17-07  Initial Creation
'  003  11-18-07  First working audio.
'  006  11-18-07  Increase edge rate on square waves.       
'  009  11-18-07  Add multi sound support.  Add play and stop controls.
'  012  11-19-07  Move to sound mixing model and change edge emphasis implementation
'  013  11-27-07  Experiment with mixed dual triangle wave for thrust
'  014  11-27-07  Go back to single triangle for thrust and refine parameters a little.
'  016  11-27-07  Add start games sound
'  017  11-27-07  Add YouDie sound (large explosion)
'  018  11-27-07  Add Warp and Mutant
'  019  11-27-07  Add LanderFire
'  020  11-28-07  Test random LFSR generator
'  021  11-28-07  Modify Thrust to use LFSR.  Temporarily disable LanderFire for code space
'  022  11-28-07  Optimized code space a little.
'                 Delete unused constants and vars.
'                 Added back in LanderFire.
'                 Used LFSR for all random generation.  
'  025  11-29-07  Merge all explosion sounds (Fire, YouDie, Warp, HumanDie, PlanetExplode) into
'                 same core handler.
'  027  12-01-07  Split sound into two engines.
'                 Moved LevelDone and StartGame into engine 2.
'                 Added Human Abducted
'                 Added capability to stop any sound (previously only applied to thrust)
'                 Added Human Caught
'  028  12-02-07  Add Pod Sound
'  029  12-04-07  Switch from bitmap to command model.
'  030  12-05-07  Collapse sound parameters into a single shared register set (SFX_REG_x)
'                   and optimize their initialization commonalities.
'                 Add EXTA_LIFE sound.
'
' //////////////////////////////////////////////////////////////////////
'
'  Audio channel usage:
'     0: Thrust
'     1: (All others)
'
' //////////////////////////////////////////////////////////////////////
CON

  CLOCK_RATE_HYDRA       = 80_000_000
  CLOCK_RATE_HYBRID      = 96_000_000
  PIN__AUDIO             = %00000000_00000000_00000000_10000000

  AUDIO_SAMPLE_RATE      = 22_000  'Audio generation rate

  '------------------------------------
  'HARDWARE IDs
  '------------------------------------
  HARDWARE_HYDRA         = 1 
  HARDWARE_HYBRID        = 2
  
  '------------------------------------
  'SOUND EFFECT COMMANDS
  '------------------------------------

  IS_UNINTERRUPTIBLE     = %1_0000_0000
  IS_EXPLOSION           = %0_1000_0000

  'Thrust Commands
  CMD__THRUST_OFF        = 0
  CMD__THRUST_HIGH       = 1
  CMD__THRUST_LOW        = 2

  'Sound Effect Commands (Engine 1)
  CMD__IDLE              = 3                                         
  CMD__HUMAN_DIE         = 4  | IS_EXPLOSION
  CMD__FIRE              = 5  | IS_EXPLOSION 
  CMD__WARP              = 6  | IS_EXPLOSION
  CMD__YOU_DIE           = 7  | IS_EXPLOSION | IS_UNINTERRUPTIBLE 
  CMD__PLANET_EXPLODE    = 8  | IS_EXPLOSION | IS_UNINTERRUPTIBLE
  CMD__MUTANT            = 9  
  CMD__LANDER_FIRE       = 10 
  CMD__LANDER_DIE        = 11 | IS_UNINTERRUPTIBLE
  CMD__HUMAN_ABDUCTED    = 12 | IS_UNINTERRUPTIBLE   
  CMD__HUMAN_FALLING     = 13 
  CMD__HUMAN_CAUGHT      = 14 
  CMD__POD               = 15 
  CMD__SWARMER           = 16
  CMD__HUMAN_RETURNED    = 17  
  CMD__EXTRA_LIFE        = 18
  CMD__EXTRA_LIFE2       = 19   'NOTE: This is the 2nd part of the 'Extra Life' sound, and should not
                                '      be called by the game engine.  EXTRA_LIFE will be followed by
                                '      EXTRA_LIFE2 automatically.

  'Sound Effect Commands (Engine 2)   
  CMD__LEVEL_DONE        = 20
  CMD__START_GAME        = 21
  CMD__HIGHSCORE         = 22

  CMD__QUIET             = $7f

     
  '------------------------------------
  'Flags
  '------------------------------------  
  FLAG_RISING_EDGE       = %00000001
  FLAG_FALLING_EDGE      = %00000010
     
  '------------------------------------
  'Misc
  '------------------------------------  
  MUTANT_SAMPLE_WIDTH_INIT = 2
  MUTANT_SAMPLES_PER_LWORD = 16

  LFIRE_SAMPLE_WIDTH_INIT = 3 
  LFIRE_SAMPLES_PER_LWORD = 32

  COG_STOPPED             = 99
  
OBJ
  'dbg       :       "PasDebug"                       '<---- Add for Debugger
  
VAR
   long               this_cog 

PUB init 
   this_cog := COG_STOPPED
  
PUB start (sfx_control_block_p)
  if this_cog == COG_STOPPED
    this_cog := cognew(@sfx_entry,sfx_control_block_p)
    'dbg.start(31,30,@sfx_entry)                '<---- Add for Debugger   

PUB stop 
  if (this_cog <> COG_STOPPED)  
    cogstop(this_cog)
    this_cog := COG_STOPPED

'///////////////////////////////////////////////////////////////////////
' DATA SECTION /////////////////////////////////////////////////////////
'///////////////////////////////////////////////////////////////////////

DAT

'  SFX_REG_x  Register Mapping:
'
'  EXPLODE:
'     SFX_REG_0  EXPLODE_phase_ticks      
'     SFX_REG_1  EXPLODE_pulse_level      
'     SFX_REG_2  EXPLODE_state_counter 
'     SFX_REG_3  EXPLODE_chunk_width  
'     SFX_REG_4  EXPLODE_chunk_step   
'     SFX_REG_5  EXPLODE_pulse_ticks  
'     SFX_REG_6  EXPLODE_pulse_sense   
'     
'  MUTANT:
'     SFX_REG_0  MUTANT_sample            
'     SFX_REG_1  MUTANT_sample_index      
'     SFX_REG_2  MUTANT_sample_width
'     SFX_REG_3  MUTANT_sample_tick 
'     SFX_REG_4  
'     SFX_REG_5  
'     SFX_REG_6  
'
'  LANDER_DIE: 
'     SFX_REG_0  LDIE_angle
'     SFX_REG_1  LDIE_angle_step
'     SFX_REG_2  LDIE_scale
'     SFX_REG_3
'     SFX_REG_4
'     SFX_REG_5
'     SFX_REG_6
'
' HUMAN_ABDUCTED:    
'     SFX_REG_0  HABD_angle0
'     SFX_REG_1  HABD_angle1
'     SFX_REG_2  HABD_angle2
'     SFX_REG_3  HABD_state_counter
'     SFX_REG_4  HABD_snd0_levels
'     SFX_REG_5  HABD_snd1_levels
'     SFX_REG_6  HABD_segment
'              
' HUMAN_FALLING:    
'     SFX_REG_0  HFALL_angle
'     SFX_REG_1  HFALL_angle_step
'     SFX_REG_2  HFALL_state_counter
'     SFX_REG_3
'     SFX_REG_4
'     SFX_REG_5
'     SFX_REG_6
'
' HUMAN_CAUGHT:    
'     SFX_REG_0  HCAUGHT_angle
'     SFX_REG_1  HCAUGHT_angle_step
'     SFX_REG_2  HCAUGHT_state_counter
'     SFX_REG_3  HCAUGHT_step_increment
'     SFX_REG_4
'     SFX_REG_5
'     SFX_REG_6
'
' MUTANT:    
'     SFX_REG_0  POD_angle
'     SFX_REG_1  POD_state_counter
'     SFX_REG_2  POD_phase_counter
'     SFX_REG_3
'     SFX_REG_4
'     SFX_REG_5
'     SFX_REG_6
'
' MUTANT:    
'     SFX_REG_0  SWARM_angle
'     SFX_REG_1  SWARM_angle_step
'     SFX_REG_2  SWARM_state_counter
'     SFX_REG_3  SWARM_phase_counter
'     SFX_REG_4
'     SFX_REG_5
'     SFX_REG_6
'
' EXTRA_LIFE:    
'     SFX_REG_0  XLIFE_phase_ticks
'     SFX_REG_1  XLIFE_gap_size
'     SFX_REG_2
'     SFX_REG_3  XLIFE_pulse_sense
'     SFX_REG_4  XLIFE_pulse_size
'     SFX_REG_5  XLIFE_pulse_ticks
'     SFX_REG_6
'

             
'------------------------------------
'Entry
'------------------------------------
                        org        0
                        
sfx_entry

'  --------- Debugger Kernel add this at Entry (Addr 0) ---------
    'long $34FC1202,$6CE81201,$83C120B,$8BC0E0A,$E87C0E03,$8BC0E0A
    'long $EC7C0E05,$A0BC1207,$5C7C0003,$5C7C0003,$7FFC,$7FF8
'  -------------------------------------------------------------- 

                        'get pointers to parameters in the Effect Control block
                        mov     r1,PAR             'Get pointer to Effect Control block

                        'Get Pointer to sfx_command
                        mov     p_sfx_cmd, r1
                        add     r1, #4

                        'Get Pointer to thrust_command
                        mov     p_thrust_cmd, r1
                        add     r1, #4

                        'Get (and process) sfx_hardware_type
                        rdlong  r2, r1             ' Get hardware id
                        cmp     r2, #HARDWARE_HYDRA wz
              if_z      mov     sample_interval_ticks, SAMPLE_INTERVAL_HYDRA
              if_nz     mov     sample_interval_ticks, SAMPLE_INTERVAL_HYBRID  

'------------------------------------
'Effect processing loop
'------------------------------------

                        '------------------------------------
                        'Init 
                        '------------------------------------
                        mov     sfx_cmd, #CMD__QUIET
                        mov     thrust_cmd, #CMD__THRUST_OFF

                        'Configure audio pin
                        andn    outa,_PIN__AUDIO       ' Set audio pin LOW          "0"
                        or      dira,_PIN__AUDIO       ' Set audio pin to OUTPUT
                        mov     ctra, CTRAVAL
                        mov     frqa, LONG_HALF
                        mov     phsa, #$ff

                        'DEBUG LED
                        or       dira, #1

                        'seed the LFSR pseudo-random generator
                        mov     random_number, #1  

:restart                        
                        mov     next_sample_start_time, cnt
                        add     next_sample_start_time, sample_interval_ticks

                        mov     previous_pulse_level, #0
                        mov     THRUST_level, #0


:sample_sync            'wait for next audio sample start time
                        waitcnt next_sample_start_time, sample_interval_ticks

                        
                        mov     flags, #0
                        mov     AUDIO_channel_0, #0

                        '------------------------------------
                        'Generate LFSR Pseudo random number                                      
                        '------------------------------------
                        mov    x, #32                              'Generate 32 bits
:lfsr_loop              mov    y, random_number
                        and    y, #1
                        neg    y, y
                        and    y, LFSR_32_TAPS
          
                        xor    random_number, y
                        ror    random_number, #1
                        sub    x, #1  wz
              if_nz     jmp    #:lfsr_loop  
 

                        '------------------------------------
                        'Get thrust command
                        '------------------------------------
                        rdlong  thrust_cmd, p_thrust_cmd 

                        '------------------------------------
                        'Get sfx command
                        '------------------------------------
                        rdlong  r1, p_sfx_cmd
                        cmp     r1, sfx_cmd_previous wz                         'IF   no new commnand
                        mov     sfx_cmd_previous, r1                           
              if_nz     cmp     r1, #CMD__IDLE wz                               'OR   command == IDLE
              if_z      jmp     #:start_bypass                                  'THEN bypass START code

                        test    sfx_cmd, #IS_UNINTERRUPTIBLE wz                 'IF   current sound is uninterruptable
              if_nz     cmp     r1, #CMD__QUIET wz                              'AND  the new sound is not CMD__QUIET
              if_nz     jmp     #:start_bypass                                  'THEN bypass START code (i.e. ignore the new command)
                        
                        
                        '================================================================================
                        'Sound STARTs
                        '================================================================================

                        mov     sfx_cmd, r1              'Accept the new command

                        ' Common initialization for all sounds
                        ' (Will be overwritten by individial sound initializations as appropriate)
   '                    cmp     sfx_cmd,#CMD__QUIET  wz
                        mov     SFX_REG_0, #0
                        mov     SFX_REG_1, #0
                        mov     SFX_REG_2, #0
                        mov     SFX_REG_3, #1
                        mov     SFX_REG_4, #1
                        mov     SFX_REG_5, #1
                        mov     SFX_REG_6, #1 
                      
                        '------------------------------------
                        'START: <All explostion types>
                        '------------------------------------
                        '
                        '  Common init code for all explosion types
                        '
                        '------------------------------------
                        test    sfx_cmd, #IS_EXPLOSION   wz    
              if_nz     mov     SFX_REG_0, FIRE_PHASE_TICK_INIT
              if_nz     mov     SFX_REG_1, LONG_HALF
              if_nz     mov     random_number, #7                'Re-seed the random number generator for all explosion starts
                                       
                        '------------------------------------
                        'START: Human Die
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__HUMAN_DIE  wz
              if_z      mov     SFX_REG_3, #$4
              if_z      mov     SFX_REG_4,           #4  

                        '------------------------------------
                        'START: Fire 
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__FIRE       wz
              if_z      shr     SFX_REG_1, #3

                        '------------------------------------
                        'START: Warp 
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__WARP       wz
              if_z      mov     SFX_REG_0, FIRE_PHASE_TICK_INIT
              if_z      mov     SFX_REG_3, #40
              if_z      neg     SFX_REG_4,           #1            'step = -1
              if_z      shr     SFX_REG_1, #3

                        '------------------------------------
                        'START: You Die 
                        '------------------------------------
                        '(Default explosion initialization is sufficient)

                        '------------------------------------
                        'START: Planet Explode
                        '------------------------------------
                        '(Default explosion initialization is sufficient)

                        '------------------------------------
                        'START: Mutant 
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__MUTANT     wz
              if_z      mov     SFX_REG_0, MUTANT_SAMPLE_1
              if_z      mov     SFX_REG_1, #MUTANT_SAMPLES_PER_LWORD
              if_z      mov     SFX_REG_2, #MUTANT_SAMPLE_WIDTH_INIT

                        '------------------------------------
                        'START: Lander Fire 
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__LANDER_FIRE  wz 
              if_z      mov     SFX_REG_0, LFIRE_SAMPLE_1
              if_z      mov     SFX_REG_1, #LFIRE_SAMPLES_PER_LWORD
              if_z      mov     SFX_REG_2, #LFIRE_SAMPLE_WIDTH_INIT
              
                        '------------------------------------
                        'START: Lander Die 
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__LANDER_DIE   wz
              if_z      mov     SFX_REG_1, LDIE_ANGLE_STEP_INIT
              if_z      mov     SFX_REG_2, #4

                        '------------------------------------
                        'START: Human Abducted
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__HUMAN_ABDUCTED  wz
              if_z      mov     SFX_REG_3, #0
              if_z      mov     SFX_REG_4, HABD_SND0_LEVEL
              if_z      mov     SFX_REG_5, HABD_SND1_LEVEL
              if_z      mov     SFX_REG_6, #15

                        '------------------------------------
                        'START: Human Fall
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__HUMAN_FALLING wz
              if_z      mov     SFX_REG_1, HFALL_ANGLE_STEP_INIT
              if_z      mov     SFX_REG_2, HFALL_DURATION
                                                                         
                        '------------------------------------
                        'START: Human Caught
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__HUMAN_CAUGHT wz
              if_z      mov     SFX_REG_1, HCAUGHT_ANGLE_STEP_INIT

                        '------------------------------------
                        'START: POD
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__POD          wz
              if_z      mov     SFX_REG_2, #24

                        '------------------------------------
                        'START: SWARMER
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__SWARMER      wz
              if_z      mov     SFX_REG_1, SWARM_ANGLE_STEP_INIT
              if_z      mov     SFX_REG_3, #12

                        '------------------------------------
                        'START: Extra Life
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__EXTRA_LIFE   wz
              if_z      mov     SFX_REG_0, XLIFE_PHASE_TICKS_INIT
              if_z      mov     SFX_REG_1, XLIFE_GAP_SIZE_INIT

:start_bypass
                        '================================================================================
                        'PLAY: Explode
                        '================================================================================
                                    

                        test    sfx_cmd, #IS_EXPLOSION   wz
              if_z      jmp     #:explode_bypass

                        add     SFX_REG_2, #1
                        
                        '------------------------------------
                        ' [You Die] Start the 2nd "bang" at the appropriate time
                        '------------------------------------
                        cmp     sfx_cmd, #CMD__YOU_DIE         wz
              if_nz     jmp     #:explode_you_die_bypass  
              if_z      cmp     SFX_REG_2, YOUDIE_BANG2_TIME wz
              if_z      mov     SFX_REG_3, #2

                        '------------------------------------
                        ' [You Die] Process lingering rumble
                        '------------------------------------
                        cmp     SFX_REG_2, YOUDIE_RUMBLE_TIME wc
              if_nc     mov     x, random_number
              if_nc     and     x, #$FF
              if_nc     add     x, #1        'keeps end case from being met prematurely
              if_nc     mov     SFX_REG_3, x
              if_nc     sub     SFX_REG_1, YOUDIE_PULSE_DECAY

                        '------------------------------------
                        ' [You Die] Process sound end
                        '------------------------------------
                        cmp     SFX_REG_2, YOUDIE_END_TIME wz
              if_z      mov     sfx_cmd, #CMD__QUIET                            'End sound
                                  
:explode_you_die_bypass

                        '------------------------------------
                        ' [Planet Explode] Start the chaotic "bangs" at random times
                        '------------------------------------
                        cmp     sfx_cmd, #CMD__PLANET_EXPLODE         wz,wc
              if_z      cmp     SFX_REG_2, PLANET_CHAOS_TIME wc
           if_nz_or_nc  jmp     #:explode_skip0
                        mov     x, random_number
                        and     x, CHAOS_PROBABILITY_MASK
                        cmp     x, #1    wz
              if_z      mov     SFX_REG_3, #2            

:explode_skip0
                        '------------------------------------
                        'Generate explosion sound
                        '------------------------------------
                        sub     SFX_REG_0, #1 wc
              if_nc     jmp     #:explode_skip1
                        mov     SFX_REG_0, FIRE_PHASE_TICK_INIT
                        add     SFX_REG_3, SFX_REG_4
                        cmp     SFX_REG_3, #60 wz               ' Reacned max 
              if_nz     cmp     SFX_REG_3, #0            wz     ' Reached min (for descending warp)     
              if_z      mov     sfx_cmd, #CMD__QUIET            ' End sound
:explode_skip1                            
                        sub     SFX_REG_5, #1            wz
              if_nz     jmp     #:explode_skip2
                        mov     x, random_number
                        and     x, #7
                        add     x, #1
                        mov     y, SFX_REG_3
                        call    #mult
                        mov     SFX_REG_5, y                     
                        xor     SFX_REG_6, #1

                        test    SFX_REG_6, #1 wz              'Set edge flags to add rise/fall edge emphasis
              if_z      or      flags, #FLAG_FALLING_EDGE        
              if_nz     or      flags, #FLAG_RISING_EDGE           

:explode_skip2
                        'Output high if PULSE_BIT is high in either pulse generator
                        mov     AUDIO_channel_0, #00

                        test    SFX_REG_6, #1 wz
              if_nz     mov     x, SFX_REG_1
              if_nz     shr     x, #22
              if_nz     mov     AUDIO_channel_0, x
          
:explode_bypass

                        '================================================================================
                        'PLAY: Mutant 
                        '================================================================================
                        cmp     sfx_cmd, #CMD__MUTANT wz
              if_nz     jmp     #:mutant_bypass

                        sub     SFX_REG_3, #1            wz          
              if_nz     jmp     #:mutant_render

                        mov     SFX_REG_3, SFX_REG_2                            'Reset the tick
                        shr     SFX_REG_3, #3
                        add     SFX_REG_3, #1
                        
                        shr     SFX_REG_0, #2                                   'Advance to next 2 bit sample
                        sub     SFX_REG_1, #1            wz
              if_nz     jmp     #:mutant_render

                        
                        mov     SFX_REG_1, #MUTANT_SAMPLES_PER_LWORD            'Reset the sample index

                        
                        mov     x, MUTANT_SAMPLE_1                              'Swap the mutant sample words 
                        mov     MUTANT_SAMPLE_1, MUTANT_SAMPLE_2
                        mov     MUTANT_SAMPLE_2, x

                        mov     SFX_REG_0, MUTANT_SAMPLE_1                      'Get the next sample word

                        add     SFX_REG_2, #1                                   'Increase the sample width       

                        cmp     SFX_REG_2, #$100 wz
              if_z      mov     sfx_cmd, #CMD__QUIET                            'End sound when max width reached

                  
                        '------------------------------------
                        'Render the 2 bit mutant sample
                        '------------------------------------    
:mutant_render          mov     AUDIO_channel_0, SFX_REG_0
                        and     AUDIO_channel_0, #3
                        shl     AUDIO_channel_0, #6
               
:mutant_bypass

                        '================================================================================
                        'PLAY: Lander Fire 
                        '================================================================================
                        cmp     sfx_cmd, #CMD__LANDER_FIRE  wz
              if_nz     jmp     #:lfire_bypass

                        sub     SFX_REG_3, #1           wz          
              if_nz     jmp     #:lfire_render

                        mov     SFX_REG_3, SFX_REG_2                           'Reset the tick
                        shr     SFX_REG_3, #2
                        add     SFX_REG_3, #1
                        
                        shr     SFX_REG_0, #1                                  'Advance to next 1 bit sample
                        sub     SFX_REG_1, #1           wz
              if_nz     jmp     #:LFIRE_render

                        
                        mov     SFX_REG_1, #LFIRE_SAMPLES_PER_LWORD            'Reset the sample index

                        
                        mov     x, LFIRE_SAMPLE_1                              'Swap the LFIRE sample words 
                        mov     LFIRE_SAMPLE_1, LFIRE_SAMPLE_2
                        mov     LFIRE_SAMPLE_2, x

                        mov     SFX_REG_0, LFIRE_SAMPLE_1                      'Get the next sample word

                        add     SFX_REG_2, #1                                  'Increase the sample width       

                        cmp     SFX_REG_2, #$20 wz
              if_z      mov     sfx_cmd, #CMD__QUIET                            ' End sound

                  
                        '------------------------------------
                        'Render the 2 bit LFIRE sample
                        '------------------------------------    
:lfire_render           mov     AUDIO_channel_0, SFX_REG_0
                        and     AUDIO_channel_0, #1
                        shl     AUDIO_channel_0, #8
                 
:lfire_bypass

                        '================================================================================
                        'PLAY: Lander Die 
                        '================================================================================  
                        cmp     sfx_cmd, #CMD__LANDER_DIE   wz
              if_nz     jmp     #:ldie_bypass


                        mov     flags, #0   'EPMTEMP: TEMP FIX TO MASK EXPLODE EDGES DURING LANDER DIE ************************************
                        
                        '------------------------------------
                        'Compute waveform
                        '------------------------------------

                        'Get sine of current angle
                        mov     r1, SFX_REG_1
                        shl     r1,#3
                        add     SFX_REG_0, r1
                        mov     sin, SFX_REG_0
                        shr     sin, #10
                        call    #getsin
                        add     sin, HALF_MAX_SIN
                        shr     sin, #9

                        'Scale by current scaling factor (4,3,2,1)
                        mov     x, sin
                        mov     y, SFX_REG_2
                        call    #mult
                        mov     sin, y

                        'Clip
                        cmp     sin, #$1ff     wc
              if_nc     mov     sin, #$1ff

                        'Decay the angle step
                        mov     x, SFX_REG_1
                        mov     y, LDIE_ANGLE_MULTIPLY
                        call    #mult
                        shr     y, #15
                        mov     SFX_REG_1, y

                        'When angle step has decayed update scaling factor
                        cmp     SFX_REG_1, #$ff wz
              if_nz     jmp     #:ldie_skip1
                        mov     SFX_REG_0, #0
                        mov     SFX_REG_1, LDIE_ANGLE_STEP_INIT
                        sub     SFX_REG_2, #1 wz
              if_z      mov     sfx_cmd, #CMD__QUIET                            ' End sound   
                        
:ldie_skip1
                        '------------------------------------
                        'Set PWM output
                        '------------------------------------
                        mov     AUDIO_channel_0, sin
:ldie_bypass

                        '================================================================================
                        'PLAY: Human abducted 
                        '================================================================================  
                        cmp     sfx_cmd, #CMD__HUMAN_ABDUCTED  wz
              if_nz     jmp     #:habd_bypass

                        mov     AUDIO_channel_0, #0
                        add     SFX_REG_3, #1

                        cmp     SFX_REG_3, HABD_SEGMENT_TIME wc
              if_nc     mov     SFX_REG_3, #0
              if_nc     mov     SFX_REG_0, #0
              if_nc     sub     SFX_REG_6, #1 wz
              if_nc     shr     SFX_REG_4, #2
              if_nc     shr     SFX_REG_5, #2        
           if_nc_and_z  mov     sfx_cmd, #CMD__QUIET                            ' End sound   

                        cmp     SFX_REG_3, HABD_SEGMENT_ON_TIME wc
              if_nc     jmp     #:habd_bypass
                        
                        '------------------------------------
                        'Compute waveform
                        '------------------------------------

                        'Compute frequency swell
                        
                        add     SFX_REG_0, HABD_SWELL_STEP   
                        mov     sin, SFX_REG_0
                        shr     sin, #10
                        call    #getsin
                        sar     sin, #1
                        
                        'Get sine of current angle
                        add     SFX_REG_1, sin                      'add in frequency swelling
                        add     SFX_REG_1, HABD_ANGLE_STEP          'add in base frequency
                        mov     sin, SFX_REG_1
                        shr     sin, #10
                        call    #getsin
                        mov     r1, sin 
                        shl     sin, #3
                        add     sin, HABD_ANGLE_STEP
                        

                        add     SFX_REG_2, sin
                        mov     sin, SFX_REG_2
                        shr     sin, #10
                        call    #getsin
                        add     sin, HALF_MAX_SIN
                        shr     sin, #7

                        '------------------------------------
                        'Set PWM output
                        '------------------------------------
                        mov     x, SFX_REG_4
                        and     x, #$3
                        shr     sin, x
                        mov     AUDIO_channel_0, sin
                        
                        neg     r1, r1
                        add     r1,HALF_MAX_SIN
                        shr     r1, #9
                        cmp     r1, #$Fc wc
                        mov     r2, #0
              if_nc     mov     r2, #$180 

                        mov     x, SFX_REG_5
                        and     x, #$3
                        shr     r2, x
                        add     AUDIO_channel_0, r2
                        
                 
                         
:habd_bypass

                        '================================================================================
                        'PLAY: Human Fall
                        '================================================================================
                        cmp     sfx_cmd, #CMD__HUMAN_FALLING   wz
              if_nz     jmp     #:hfall_bypass
                        
                        '------------------------------------
                        'Compute waveform
                        '------------------------------------

                        'Get sine of current angle
                        add     SFX_REG_0, SFX_REG_1
                        sub     SFX_REG_1, #$3
                        mov     sin, SFX_REG_0
                        shr     sin, #10
                        call    #getsin
                        add     sin, HALF_MAX_SIN
                        shr     sin, #9
                        and     sin, #$C0    ' Drop lower bits to give a little grainyness   

                        '------------------------------------
                        'Determine end time
                        '------------------------------------
                        sub     SFX_REG_2, #1            wz
              if_z      mov     sfx_cmd, #CMD__QUIET                            ' End sound  

                        '------------------------------------
                        'Set PWM output
                        '------------------------------------
                        mov     AUDIO_channel_0, sin
:hfall_bypass


                        '================================================================================
                        'PLAY: Human Caught
                        '================================================================================
                        cmp     sfx_cmd, #CMD__HUMAN_CAUGHT    wz
              if_nz     jmp     #:hcaught_bypass

                        '------------------------------------
                        'Compute waveform
                        '------------------------------------

                        'Get sine of current angle
                        add     SFX_REG_0, SFX_REG_1
                        add     SFX_REG_1, #$20
                        mov     sin, SFX_REG_0
                        shr     sin, #10
                        call    #getsin
                        add     sin, HALF_MAX_SIN
                        shr     sin, #9
                        and     sin, #$C0    ' Drop lower bits to emulate "stair step" of original sound

                        '------------------------------------
                        'Determine end time
                        '------------------------------------
                        add     SFX_REG_2, #1
                        
                        cmp     SFX_REG_2, HCAUGHT_SWEEP2_TIME wz
              if_z      mov     SFX_REG_1, HCAUGHT_ANGLE_STEP_INIT
                  
                        cmp     SFX_REG_2, HCAUGHT_SWEEP3_TIME wz
              if_z      mov     SFX_REG_1, HCAUGHT_ANGLE_STEP_INIT
              if_z      mov     SFX_REG_3, #20 

                        cmp     SFX_REG_2, HCAUGHT_SWEEP_FAST_TIME wc
              if_nc add         SFX_REG_3, #11              
              if_nc mov         r2, SFX_REG_3
              if_nc shr         r2, #7 
              if_nc add         SFX_REG_1, r2
                  
                        cmp     SFX_REG_2, HCAUGHT_END_TIME wz
              if_z      mov     sfx_cmd, #CMD__QUIET                            ' End sound   

                        '------------------------------------
                        'Set PWM output
                        '------------------------------------
                        mov     AUDIO_channel_0, sin
:hcaught_bypass

                        '================================================================================
                        'PLAY: Pod
                        '================================================================================
                        cmp     sfx_cmd, #CMD__POD             wz
              if_nz     jmp     #:pod_bypass
                       
                        '------------------------------------
                        'Update angles
                        '------------------------------------
                        add     SFX_REG_1, #1
                        cmp     SFX_REG_1, POD_PHASE1_TIME wc
              if_c      add     SFX_REG_0, POD_ANGLE_STEP1
              if_nc add         SFX_REG_0, POD_ANGLE_STEP2

                        '------------------------------------
                        'Manage phase and ending
                        '------------------------------------
                        cmp     SFX_REG_1, POD_PHASE2_TIME wz
              if_z      mov     SFX_REG_1, #0
              if_z      sub     SFX_REG_2, #1          wz
              if_z      mov     sfx_cmd, #CMD__QUIET                            ' End sound   

                        '------------------------------------
                        'Compute waveform
                        '------------------------------------
                        mov     sin, SFX_REG_0
                        shr     sin, #10
                        call    #getsin
                        add     sin, HALF_MAX_SIN
                        shr     sin, #9
                        and     sin, #$C0    ' Drop lower bits to emulate "stair step" of original sound

                        '------------------------------------
                        'Set PWM output
                        '------------------------------------
                        mov     AUDIO_channel_0, sin
:pod_bypass

                        '================================================================================
                        'PLAY: Swarmer
                        '================================================================================
                        cmp     sfx_cmd, #CMD__SWARMER         wz
              if_nz     jmp     #:swarmer_bypass
                       
                        '------------------------------------
                        'Update angles
                        '------------------------------------
                        add     SFX_REG_2, #1
                        cmp     SFX_REG_2, SWARM_PHASE_TIME wz
              if_z      mov     SFX_REG_2, #0
              if_z      mov     SFX_REG_1, SWARM_ANGLE_STEP_INIT
              if_z      sub     SFX_REG_3, #1 wz
              if_z      mov     sfx_cmd, #CMD__QUIET                            ' End sound

                        sub     SFX_REG_1, #$08
                        add     SFX_REG_0, SFX_REG_1

                        '------------------------------------
                        'Compute waveform
                        '------------------------------------
                        mov     sin, SFX_REG_0
                        shr     sin, #10
                        call    #getsin
                        add     sin, HALF_MAX_SIN
                        shr     sin, #9
                        and     sin, #$C0    ' Drop lower bits to emulate "stair step" of original sound

                        '------------------------------------
                        'Set PWM output
                        '------------------------------------
                        mov     AUDIO_channel_0, sin
:swarmer_bypass
                        '================================================================================
                        'PLAY: Extra Life
                        '================================================================================
                        cmp     sfx_cmd, #CMD__EXTRA_LIFE      wz
              if_nz     jmp     #:xlife_bypass
                       

                        sub     SFX_REG_5, #1  wz                               '--XLIFE_pulse_ticks
              if_nz     jmp     #:xlife_skip1                                   'IF(XLIFE_pulse_ticks == 0)  {
                        xor     SFX_REG_3, #1                                   '  Toggle XLIFE_pulse_sense
                        test    SFX_REG_3, #1 wz                                '  IF XLIFE_pulse_sense == 0
              if_z      mov     SFX_REG_5, SFX_REG_1                            '  XLIFE_pulse_ticks = XLIFE_gap_size >> 2
              if_z      shr     SFX_REG_5, #2                                    
              if_nz     mov     SFX_REG_5, SFX_REG_4                            '  XLIFE_pulse_ticks = XLIFE_pulse_size
:xlife_skip1                                                                    '}

                                    
                        sub     SFX_REG_0, #1 wz                                'IF(--XLIFE_phase_ticks == 0)
              if_nz     jmp     #:xlife_skip2                                   '{
                        sub     SFX_REG_1, #7                                   '  XLFIFE_gap_size -= 4
                        mov     SFX_REG_0, XLIFE_PHASE_TICKS_INIT               '  XLIFE_phase_ticks = XLIFE_PHASE_TICKS_INIT
                        add     SFX_REG_4, #9                                   '  XLIFE_pulse_size += 9
                        cmp     SFX_REG_4, #28 wz                               '  IF(XLIFE_pulse_size == 28) {
              if_z      mov     SFX_REG_4, #1                                   '    XLIFE_pulse_size = 1 }     
                                                                                '}
:xlife_skip2

                        cmp     SFX_REG_1, #42 wc                               'IF( XLIFE_gap_size == 12) {
              if_c      mov     SFX_REG_1, #4
              if_c      mov     SFX_REG_6, #5
              if_c      mov     SFX_REG_5, #1
              if_c      mov     SFX_REG_4, #5
              if_c      mov     SFX_REG_0, XLIFE_PHASE_TICKS_INIT
              if_c      mov     sfx_cmd, #CMD__EXTRA_LIFE2                      ' Play second part of sound }

                        jmp     #:xlife_render
:xlife_bypass 
                        '================================================================================
                        'PLAY: Extra Life 2 (second part of extra life sound)
                        '================================================================================
                        cmp     sfx_cmd, #CMD__EXTRA_LIFE2     wz
              if_nz     jmp     #:xlife2_bypass
                       

                        sub     SFX_REG_5, #1  wz                               '--XLIFE_pulse_ticks
              if_nz     jmp     #:xlife2_skip1                                  'IF(XLIFE_pulse_ticks == 0)  {
                        xor     SFX_REG_3, #1                                   '  Toggle XLIFE_pulse_sense
                        test    SFX_REG_3, #1  wz                               '  IF XLIFE_pulse_sense == 0
              if_z      mov     SFX_REG_5, SFX_REG_1                            '  XLIFE_pulse_ticks = XLIFE_gap_size >> 2
              if_z      shr     SFX_REG_5, #2
              if_nz     mov     SFX_REG_5, SFX_REG_4                            ' XLIFE_pulse_ticks = XLIFE_pulse_size

:xlife2_skip1                                                                   '}

                        sub     SFX_REG_0, #1 wz                                'IF(--XLIFE_phase_ticks == 0) {
              if_z      mov     SFX_REG_0, XLIFE_PHASE_TICKS_INIT               '  XLIFE_phase_ticks = XLIFE_PHASE_TICKS_INIT 
              if_z      add     SFX_REG_1, #$40                                 ' ++XLIFE_gap_size
                                                                                '}
              
                        cmp     SFX_REG_1, XLIFE_GAP_SIZE_INIT wc               'IF( XLIFE_gap_size == ??){
              if_nc     sub     SFX_REG_6, #1  wz
       if_nc_and_nz     mov     SFX_REG_1, SFX_REG_6
       if_nc_and_nz     add     SFX_REG_1, #1
       if_nc_and_nz     and     SFX_REG_1, #1
       if_nc_and_nz     shl     SFX_REG_1, #4
       if_nc_and_nz     add     SFX_REG_1, #4
       if_nc_and_z      mov     sfx_cmd, #CMD__QUIET                            '  End the sound }

                        
:xlife_render    
                        test    SFX_REG_3, #1 wz                                'Set edge flags to add rise/fall edge emphasis
              if_z      or      flags, #FLAG_FALLING_EDGE
              if_z      mov     AUDIO_channel_0, #00         
              if_nz     or      flags, #FLAG_RISING_EDGE
              if_nz     mov     AUDIO_channel_0, #$ff

:xlife2_bypass

                        '================================================================================
                        'PLAY: Thrust
                        '================================================================================
                        cmp     thrust_cmd, #CMD__THRUST_HIGH wz
              if_nz     cmp     thrust_cmd, #CMD__THRUST_LOW  wz 
              if_nz     jmp #:thrust_bypass

                        'Generate sound
                        mov     x, random_number
                        and     x, #$1fe
                        add     THRUST_counter, #1
                        mov     y, THRUST_counter
                        cmp     thrust_cmd, #CMD__THRUST_HIGH wz                'IF THRUST_HIGH 
              if_z      and     y, #$F                                          '     Generate high pitched thrust
              if_nz     and     y, #$7F                                         'ELSE Generrate low pitched thrust
              if_nz     and     x, #$7F                                         '     With lower volume
                        cmp     y, #1 wz                                                                     
              if_z      mov     THRUST_level, x
                        add     AUDIO_channel_0, THRUST_level  
                        
:thrust_bypass
                        '================================================================================
                        'Audio Mixing
                        '================================================================================

                        '------------------------------------
                        'Adjust zero bias
                        '------------------------------------                                                                                                        
                        shl     AUDIO_channel_0, #18
                        add     AUDIO_channel_0, LONG_HALF

                        '------------------------------------
                        'Add edge emphasis to increase square wave rise times
                        '------------------------------------
                        
                        'Add edge emphasis if transitioning
                        mov     r1, EDGE_EMPHASIS_INIT
                        cmp     sfx_cmd, #CMD__EXTRA_LIFE  wz
                  if_nz cmp     sfx_cmd, #CMD__EXTRA_LIFE2 wz
                  if_z shr      r1, #2                                          'Use quieter edge emphasis for EXTRA_LIFE sound
                  
                        test    flags, #FLAG_RISING_EDGE   wz
                  if_nz add     AUDIO_channel_0, r1                             'add edge emphasis
                        test    flags, #FLAG_FALLING_EDGE  wz
                  if_nz sub     AUDIO_channel_0, r1                             'add edge emphasis
                        
                        '------------------------------------
                        'Output wave data
                        '------------------------------------
                        mov     frqa, AUDIO_channel_0

                        

                        '================================================================================
                        'Done main loop
                        '================================================================================
                        
                        jmp     #:sample_sync


'------------------------------------ 
' Get sine/cosine
'
'       quadrant:    1            2            3            4
'          angle:    $0000..$07FF $0800..$0FFF $1000..$17FF $1800..$1FFF
'    table index:    $0000..$07FF $0800..$0001 $0000..$07FF $0800..$0001
'         mirror:    +offset      -offset      +offset      -offset
'           flip:    +sample      +sample      -sample      -sample
'
' on entry: sin[12..0] holds angle (0 to just under 360)
' on exit: sin holds signed value ranging from $0000FFFF ('1') to
' $FFFF0001 ('-1')
'------------------------------------ 
getcos                  add     sin,sin_90      'for cosine, add 90
getsin                  test    sin,sin_90 wc   'get quadrant 2|4 into c
                        test    sin,sin_180 wz  'get quadrant 3|4 into nz
                        negc    sin,sin         'if quadrant 2|4, negate offset
                        or      sin,sin_table   'or in sin table address >> 1
                        shl     sin,#1          'shift left to get final word address
                        rdword  sin,sin         'read word sample from $E000 to $F000
                        negnz   sin,sin         'if quadrant 3|4, negate sample
getsin_ret
getcos_ret              ret                     '39..54 clocks
                                                '(variance due to HUB sync on RDWORD)
sin_90                  long    $0800
sin_180                 long    $1000
sin_table               long    $E000 >> 1      'sine table base shifted right
sin                     long    0
HALF_MAX_SIN            long    $FFFF                               


'------------------------------------
'Multiply                                    
'------------------------------------
' Multiply x[15..0] by y[15..0] (y[31..16] must be 0)
' on exit, product in y[31..0]
'------------------------------------
mult                    shl x,#16               'get multiplicand into x[31..16]
                        mov t,#16               'ready for 16 multiplier bits
                        shr y,#1 wc             'get initial multiplier bit into c
:loop
                        if_c add y,x wc         'conditionally add multiplicand into product
                        rcr y,#1 wc             'get next multiplier bit into c.
                                                ' while shift product
                        djnz t,#:loop           'loop until done
mult_ret                ret                     'return with product in y[31..0]

'------------------------------------
'Initialized Data                                      
'------------------------------------
_PIN__AUDIO             long    PIN__AUDIO

SAMPLE_INTERVAL_HYDRA   long   (CLOCK_RATE_HYDRA / AUDIO_SAMPLE_RATE)
SAMPLE_INTERVAL_HYBRID  long   (CLOCK_RATE_HYBRID / AUDIO_SAMPLE_RATE)    

CTRAVAL                 long   %00110 << 26 + 7  'DUTY single-ended, APIN=7        '
LONG_HALF               long   $7FFF_FFFF

LFSR_32_TAPS            long   $800000c2

'EDGE_EMPHASIS_INIT     long   $0fffffff
EDGE_EMPHASIS_INIT      long   $0fffffff 

LDIE_ANGLE_STEP_INIT    long   $0000693a
LDIE_ANGLE_MULTIPLY     long   $00007Fd9 

FIRE_PHASE_TICK_INIT    long   $00000300

'RANDOM_DELTA            long   $9e3779b9

SGAME_ANGLE_STEP        long   $0000f587
SGAME_ANGLE_END         long   $00800000

YOUDIE_BANG2_TIME       long   $00001000
YOUDIE_RUMBLE_TIME      long   $00007000
YOUDIE_END_TIME         long   $00020000
YOUDIE_PULSE_DECAY      long   $00005000

PLANET_CHAOS_TIME       long   $0001C000
CHAOS_PROBABILITY_MASK  long   $000007FF

MUTANT_SAMPLE_1         long   %01_10_00_11_00_10_01_00___01_10_00_11_00_10_01_00  ' 2 bit sample representation
MUTANT_SAMPLE_2         long   %01_01_01_01_01_01_01_01___01_10_00_11_00_10_01_00  ' of the mutant waveform                                                                                 

LFIRE_SAMPLE_1          Long   %01111101_11110111_11010110_00100101  ' 1 Bit sample representation 
LFIRE_SAMPLE_2          long   %00000000_00000101_00100011_01011111  ' of the lander fire waveform

HABD_SWELL_STEP         long   $00001800  
HABD_ANGLE_STEP         long   $00040500
HABD_SEGMENT_TIME       long   $00000500
HABD_SEGMENT_ON_TIME    long   $00000480
                               'These are 2 bit representations of the sound levels of the two sound components
                               'in the HABD sound for each segment, right to left in time
HABD_SND0_LEVEL         long   %11_10_10_10_01_00_00_01_01_10_11_11_00_10_00_00  ' Wavey sound   
HABD_SND1_LEVEL         long   %11_00_01_00_00_00_00_00_01_01_10_00_11_11_11_11  ' Sharp pulse sound

HFALL_ANGLE_STEP_INIT   long   $00060500
HFALL_DURATION          long   $00018000

HCAUGHT_ANGLE_STEP_INIT long   99383
HCAUGHT_SWEEP2_TIME     long   3753   
HCAUGHT_SWEEP3_TIME     long   7506
HCAUGHT_SWEEP_FAST_TIME long   9500        
HCAUGHT_END_TIME        long   12495

POD_ANGLE_STEP1         long   48648
POD_ANGLE_STEP2         long   291428
POD_PHASE1_TIME         long   562
POD_PHASE2_TIME         long   668 

SWARM_ANGLE_STEP_INIT   long   179000
SWARM_PHASE_TIME        long   2000

XLIFE_PHASE_TICKS_INIT  long   700
XLIFE_GAP_SIZE_INIT     long   440

'------------------------------------
'Uninitialized Data
'------------------------------------
sfx_cmd_previous          res     1
sfx_cmd                   res     1
thrust_cmd                res     1

p_sfx_cmd                 res     1
p_thrust_cmd              res     1

                          
r1                        res     1
r2                        res     1
sfx_id_mask               res     1
flags                     res     1
sample_interval_ticks     res     1

x                         res     1    ' for multiply
y                         res     1    ' for multiply
t                         res     1    ' for multiply

previous_pulse_level      res     1

next_sample_start_time    res     1

random_number             res     1

'THRUST parameters
THRUST_level              res     1
THRUST_counter            res     1

'Audio channels
AUDIO_channel_0           res     1                                       

'Sound parameter registers
SFX_REG_0                 res     1
SFX_REG_1                 res     1
SFX_REG_2                 res     1
SFX_REG_3                 res     1
SFX_REG_4                 res     1
SFX_REG_5                 res     1
SFX_REG_6                 res     1


                          fit                 